'From Squeak3.8 of ''5 May 2005'' [latest update: #6665] on 15 February 2006 at 3:39:39 pm'!
"Change Set:		JMMMacServices
Date:			13 June 2005
Author:			johnmci@smalltalkconsulting.com

Mac Services, used by the Services logic to allow squeak to service requests from other application. The intial release executes the supplied UTF-8 string, then returns the result to the calling application"!

Object subclass: #MacServicesInterface
	instanceVariableNames: 'servicesSemaphore servicesSemaIndex'
	classVariableNames: 'Current MacServicesProcess'
	poolDictionaries: ''
	category: 'Network-RemoteDirectory'!

!MacServicesInterface commentStamp: '<historical>' prior: 0!
Mac Services interface.
uses ServicesPlugin
by
John M McIntosh
johnmci@smalltalkconsulting.com
June 15th 2005
!


!MacServicesInterface methodsFor: 'accessing' stamp: 'JMM 9/8/2005 10:14'!
getBytes
	^self primGetBytes! !

!MacServicesInterface methodsFor: 'accessing' stamp: 'JMM 6/12/2005 13:43'!
getTextString
	^self primGetTextString! !

!MacServicesInterface methodsFor: 'accessing' stamp: 'JMM 6/12/2005 14:24'!
setBasicType
	self setDataTypes: 'TEXT'! !

!MacServicesInterface methodsFor: 'accessing' stamp: 'JMM 9/8/2005 10:14'!
setBytes: aByteString
	self primSetBytes: aByteString! !

!MacServicesInterface methodsFor: 'accessing' stamp: 'JMM 9/8/2005 10:16'!
setCopyOSType: aString
	self primSetCopyOSTypeString: aString! !

!MacServicesInterface methodsFor: 'accessing' stamp: 'JMM 9/8/2005 13:03'!
setDataTypes: aDataTypeArray
	"Needs a string of OSTypes, ie TEXTTIFF"
	"Types could be:
  kScrapFlavorTypePicture       = 'PICT', /* contents of a PicHandle*/
  kScrapFlavorTypeText          = 'TEXT', /* stream of characters*/
  kScrapFlavorTypeTextStyle     = 'styl', /* see TEGetStyleScrapHandle*/
  kScrapFlavorTypeMovie         = 'moov', /* reference to a movie*/
  kScrapFlavorTypeSound         = 'snd ', /* see SndRecord and SndPlay*/
  kScrapFlavorTypeUnicode       = 'utxt', /* stream of UTF16 characters*/
  kScrapFlavorTypeUnicodeStyle  = 'ustl' /* ATSUI defines; Textension uses*/

	also other types like TIFF

	"
	self primSetDataTypes: aDataTypeArray! !

!MacServicesInterface methodsFor: 'accessing' stamp: 'JMM 9/8/2005 10:16'!
setPasteOSType: aString
	self primSetPasteOSTypeString: aString! !

!MacServicesInterface methodsFor: 'accessing' stamp: 'JMM 9/8/2005 10:16'!
setPerformOSType: aString
	self primSetPerformOSTypeString: aString! !

!MacServicesInterface methodsFor: 'accessing' stamp: 'JMM 9/8/2005 13:42'!
setReturnBytes: aString osType: aType
	self primSetReturnBytes: aString osType: aType! !

!MacServicesInterface methodsFor: 'accessing' stamp: 'JMM 6/12/2005 15:14'!
setReturnTextString: aString
	self primSetReturnTextString: aString! !

!MacServicesInterface methodsFor: 'accessing' stamp: 'JMM 6/12/2005 13:40'!
setTextString: aString
	self primSetTextString: aString! !

!MacServicesInterface methodsFor: 'initialize-release' stamp: 'JMM 6/13/2005 21:31'!
initialize
	self installSemaphore.
	self setBasicType.
	self installServicesProcess! !

!MacServicesInterface methodsFor: 'initialize-release' stamp: 'JMM 6/13/2005 21:44'!
installSemaphore
	servicesSemaphore := Semaphore new.
	servicesSemaIndex := Smalltalk registerExternalObject: servicesSemaphore.
	self primSetSemaphore: servicesSemaIndex.

! !

!MacServicesInterface methodsFor: 'initialize-release' stamp: 'JMM 6/13/2005 21:27'!
installServicesProcess
	MacServicesProcess ifNotNil: [MacServicesProcess terminate].
	MacServicesProcess := [self macServicesProcessLogic] forkAt: Processor userBackgroundPriority.
! !

!MacServicesInterface methodsFor: 'system primitives' stamp: 'JMM 9/8/2005 10:10'!
primGetBytes

	<primitive:'primitiveGetBytes' module: 'ServicesPlugin'>
! !

!MacServicesInterface methodsFor: 'system primitives' stamp: 'JMM 6/12/2005 13:42'!
primGetTextString

	<primitive:'primitiveGetTextString' module: 'ServicesPlugin'>
! !

!MacServicesInterface methodsFor: 'system primitives' stamp: 'JMM 9/8/2005 10:11'!
primSetBytes: aString

	<primitive:'primitiveSetBytes' module: 'ServicesPlugin'>
! !

!MacServicesInterface methodsFor: 'system primitives' stamp: 'JMM 9/8/2005 10:12'!
primSetCopyOSTypeString: aString

	<primitive:'primitiveSetCopyOSTypeString' module: 'ServicesPlugin'>
! !

!MacServicesInterface methodsFor: 'system primitives' stamp: 'JMM 6/12/2005 13:38'!
primSetDataTypes: typeString

	<primitive:'primitiveSetDataTypes' module: 'ServicesPlugin'>
! !

!MacServicesInterface methodsFor: 'system primitives' stamp: 'JMM 9/8/2005 10:12'!
primSetPasteOSTypeString: aString

	<primitive:'primitiveSetPasteOSTypeString' module: 'ServicesPlugin'>
! !

!MacServicesInterface methodsFor: 'system primitives' stamp: 'JMM 9/8/2005 10:13'!
primSetPerformOSTypeString: aString

	<primitive:'primitiveSetPerformOSTypeString' module: 'ServicesPlugin'>
! !

!MacServicesInterface methodsFor: 'system primitives' stamp: 'JMM 9/8/2005 13:39'!
primSetReturnBytes: aString osType: aType

	<primitive:'primitiveSetReturnBytes' module: 'ServicesPlugin'>
! !

!MacServicesInterface methodsFor: 'system primitives' stamp: 'JMM 6/12/2005 15:14'!
primSetReturnTextString: aString

	<primitive:'primitiveSetReturnTextString' module: 'ServicesPlugin'>
! !

!MacServicesInterface methodsFor: 'system primitives' stamp: 'JMM 6/13/2005 21:39'!
primSetSemaphore: aSemaIndex

	<primitive:'primitiveSetSemaphore' module: 'ServicesPlugin'>
! !

!MacServicesInterface methodsFor: 'system primitives' stamp: 'JMM 6/12/2005 14:30'!
primSetTextString: aString

	<primitive:'primitiveSetTextString' module: 'ServicesPlugin'>
! !

!MacServicesInterface methodsFor: 'process' stamp: 'JMM 9/8/2005 13:43'!
getDataExecuteAndReturn
	| string results resultsString |

	string := self getBytes.
	results := Compiler evaluate: string asString.
	resultsString := results printString.
	self setReturnBytes: resultsString asByteArray osType: 'TEXT'. ! !

!MacServicesInterface methodsFor: 'process' stamp: 'JMM 9/8/2005 13:43'!
macServicesProcessLogic

	[servicesSemaphore wait.
	[self getDataExecuteAndReturn] on: Error do: [:ex | self setReturnBytes: String new osType: 'TEXT'].
	true ] whileTrue.! !


!MacServicesInterface class methodsFor: 'accessing' stamp: 'JMM 6/13/2005 21:21'!
current
	Current ifNil: [Current := self new].
	^Current! !

!MacServicesInterface class methodsFor: 'initialize-release' stamp: 'JMM 6/13/2005 21:21'!
shutDown: quitting
! !

!MacServicesInterface class methodsFor: 'initialize-release' stamp: 'JMM 6/13/2005 21:34'!
startUp: resuming
	"The image is either being newly started (resuming is true), or it's just been snapshotted"

	Current := nil.
	self current.! !

!MacServicesInterface class methodsFor: 'class initialization' stamp: 'JMM 6/13/2005 21:19'!
initialize
	"MacServicesInterface initialize"
	Smalltalk addToStartUpList: self after: nil.
	Smalltalk addToShutDownList: self after: nil.! !

MacServicesInterface initialize!

!MacServicesInterface class reorganize!
('accessing' current)
('initialize-release' shutDown: startUp:)
('class initialization' initialize)
!


!MacServicesInterface reorganize!
('accessing' getBytes getTextString setBasicType setBytes: setCopyOSType: setDataTypes: setPasteOSType: setPerformOSType: setReturnBytes:osType: setReturnTextString: setTextString:)
('initialize-release' initialize installSemaphore installServicesProcess)
('system primitives' primGetBytes primGetTextString primSetBytes: primSetCopyOSTypeString: primSetDataTypes: primSetPasteOSTypeString: primSetPerformOSTypeString: primSetReturnBytes:osType: primSetReturnTextString: primSetSemaphore: primSetTextString:)
('process' getDataExecuteAndReturn macServicesProcessLogic)
!

